
// Neurosis Engine - LP23.com
// Copyright  Luigi Pino. All rights reserved.

/***************************************************************************/

#ifndef _NEUROSIS_ENGINE_IO_MISC_H_
#define _NEUROSIS_ENGINE_IO_MISC_H_

/***************************************************************************/

//------------------------------------------------
#define NOTHING_PRESSED						0
#define BUTTON_1									1
#define BUTTON_2									2
#define BUTTON_3									4
#define BUTTON_4									8
#define BUTTON_5									16
#define BUTTON_6									32
#define BUTTON_7									64
#define BUTTON_8									128
#define BUTTON_9									256
//------------------------------------------------
#define UP												0
#define DOWN											1
#define LEFT											2
#define RIGHT											3
//------------------------------------------------
#define MOUSE											0
#define KEYBOARD_1								1
#define KEYBOARD_2								2
#define JOYSTICK_1								3
#define JOYSTICK_2								4
#define JOYSTICK_3								5
#define JOYSTICK_4								6
#define COMPUTER									7
#define NO_USER										8
//------------------------------------------------

/***************************************************************************/

class CNeurosisController {
	private:
		class CJoystick {
			public:
				CJoystick();
				//! Constructor/Deconstructor
				~CJoystick();

				//! Get joystick registry value
				MMRESULT Get_Joystick_Name(UINT id, TCHAR * pszName);

				int				mAxis4;															// Forth axis
				int				mAxis5;															// Fifth axis
				int				mAxis6;															// Sixth axis
				int				mPOV;																// Point of view
				JOYINFOEX	info;																// Info tag
			};

		class CKeyboard {
			public:
				CKeyboard();
				//! Constructor/Deconstructor
				~CKeyboard();

				//! Map keys to be used for buttons, and movement
				void Set_Keys(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7, int b8, int up, int down, int left, int right);

				int	mButtonID[9];															// Button ID
				int	mDirectionID[4];													// Direction ID
			};

		class CMouse {
			public:
				CMouse();
				//! Constructor/Deconstructor
				~CMouse();

				float3	mChange;															// Change in position
				POINT		mCurrent;															// New position
				POINT		mPrevious;														// Old position
			};

	public:
		CNeurosisController(int iType = MOUSE);
		//! Constructor/Deconstructor
		~CNeurosisController();

		//!	Clear button and movement input
		void	Clear();
		//! Check whether button press is within interval
		bool	Interval(float2 *key, float interval);
		//!	Update joystick/keyboard button/movement information
		void	Update(float timeStep, bool mouseBoundsReset);

		CJoystick				mJoystick;												// Joystick input
		CKeyboard				mKeyboard;												// Keyboard input
		CMouse					mMouse;														// Mouse input
		float2					mButton[9];												// \	Amount pressed:	x (current interval)
		float2					mDirection[4];										// /									y (total interval)
		int							mType;														// Mouse, Keyboard, Joystick, Computer or None
};

/***************************************************************************/

class CNeurosisTiming {
	public:
		CNeurosisTiming();
		//! Constructor/Deconstructor
		~CNeurosisTiming();

		//!	Get mProcessorSpeed value
		float	Get_Processor_Speed();
		//! Get mTimeStep value
		float	Get_Time_Step();
		//! Set mTimeStep value
		void	Set_Time_Step(float amount);
		//! Update timing class with current cpu cycle
		void	Update();

	private:
		void			Calculate_Frequency();
		unsigned	Get_CPU_Cycle();

		bool			mPrecision;															// Which timing function to use
		float			mProcessorSpeed;												// MHz of computer
		float			mTimeStep;															// Time between cycle calls (1/x = FPS)
		unsigned	mCycleBegin;														// Start of cycle call
		unsigned	mCycleEnd;															// End of cycle call
};

/***************************************************************************/
#endif